/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.IllegalJsonArgumentException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.tree.ThisObject;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import java.util.Collections;
import java.util.List;

public class UpdateAssignment
extends BinaryOperatorExpression {
    public UpdateAssignment(JsonQuery lhs, JsonQuery rhs) {
        super(lhs, rhs, "|=");
    }

    @Override
    public List<JsonNode> apply(final Scope scope, JsonNode in) throws JsonQueryException {
        if (!(this.lhs instanceof FieldAccess)) {
            throw new IllegalJsonArgumentException("left hand side must be FieldAccess");
        }
        FieldAccess.ResolvedPath resolvedPath = ((FieldAccess)this.lhs).resolvePath(scope, in);
        if (!(resolvedPath.target instanceof ThisObject)) {
            throw new IllegalJsonArgumentException("cannot update value");
        }
        return Collections.singletonList(JsonNodeUtils.mutate(scope.getObjectMapper(), in, resolvedPath.path, new JsonNodeUtils.Mutation(){

            @Override
            public JsonNode apply(JsonNode node) throws JsonQueryException {
                List<JsonNode> rvalues = UpdateAssignment.this.rhs.apply(scope, node);
                if (rvalues.isEmpty()) {
                    return NullNode.getInstance();
                }
                return rvalues.get(rvalues.size() - 1);
            }
        }, true));
    }
}

