/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.Range;
import com.groupbyinc.common.jackson.jq.internal.misc.UnicodeUtils;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResolvedRangeFieldAccess
extends ResolvedFieldAccess {
    private List<Range> ranges;

    public ResolvedRangeFieldAccess(boolean permissive, List<Range> ranges) {
        super(permissive);
        this.ranges = ranges;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (Range range : this.ranges) {
            if (in.isArray()) {
                Range r = range.over(in.size());
                ArrayNode array = scope.getObjectMapper().createArrayNode();
                for (int index = (int)r.begin; index < (int)r.end; ++index) {
                    array.add(in.get(index));
                }
                out.add(array);
                continue;
            }
            if (in.isTextual()) {
                String _in = in.asText();
                Range r = range.over(UnicodeUtils.lengthUtf32(_in));
                out.add(new TextNode(UnicodeUtils.substringUtf32(_in, (int)r.begin, (int)r.end)));
                continue;
            }
            if (in.isNull()) {
                out.add(NullNode.getInstance());
                continue;
            }
            if (this.permissive) continue;
            throw JsonQueryException.format("Cannot index %s with object", new Object[]{in.getNodeType()});
        }
        return out;
    }

    public List<Range> ranges() {
        return Collections.unmodifiableList(this.ranges);
    }
}

