/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeComparator;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMaxFunction
implements Function {
    protected static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();
    private String fname;

    public AbstractMaxFunction(String fname) {
        this.fname = fname;
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType(this.fname, in, JsonNodeType.ARRAY);
        JsonNode maxItem = NullNode.getInstance();
        ArrayNode maxValue = null;
        for (JsonNode i : in) {
            ArrayNode value = JsonNodeUtils.asArrayNode(scope.getObjectMapper(), args.get(0).apply(scope, i));
            if (maxValue != null && this.isLarger(maxValue, value)) continue;
            maxValue = value;
            maxItem = i;
        }
        return Collections.singletonList(maxItem);
    }

    protected abstract boolean isLarger(JsonNode var1, JsonNode var2);
}

