/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.BooleanNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"has/1"})
public class HasFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode keyName : args.get(0).apply(scope, in)) {
            if (in.isObject()) {
                if (!keyName.isTextual()) {
                    throw new JsonQueryException("argument 1 of has() must be string for object input");
                }
                out.add(BooleanNode.valueOf(in.has(keyName.asText())));
                continue;
            }
            if (in.isArray()) {
                if (!keyName.isIntegralNumber()) {
                    throw new JsonQueryException("argument 1 of has() must be int for array input");
                }
                out.add(BooleanNode.valueOf(in.has(keyName.asInt())));
                continue;
            }
            throw new JsonQueryException("has() is not applicable to " + (Object)((Object)in.getNodeType()));
        }
        return out;
    }
}

