/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"ltrimstr/1"})
public class LTrimStrFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("ltrimstr", in, JsonNodeType.STRING);
        String text = in.asText();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode prefixNode : args.get(0).apply(scope, in)) {
            if (!prefixNode.isTextual()) {
                throw new JsonQueryException("1st argument to ltrimstr() must be string, got " + (Object)((Object)prefixNode.getNodeType()));
            }
            String prefix = prefixNode.asText();
            if (!text.startsWith(prefix)) {
                out.add(in);
                continue;
            }
            out.add(new TextNode(text.substring(prefix.length(), text.length())));
        }
        return out;
    }
}

