/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.functions.IndicesFunction;
import java.util.ArrayList;
import java.util.List;

@BuiltinFunction(value={"rindex/1"})
public class RIndexFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (JsonNode needle : args.get(0).apply(scope, in)) {
            List<Integer> tmp = IndicesFunction.indices(needle, in);
            if (tmp.isEmpty()) {
                out.add(NullNode.getInstance());
                continue;
            }
            out.add(new IntNode(tmp.get(tmp.size() - 1)));
        }
        return out;
    }
}

