/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.core.JsonGenerator;
import com.groupbyinc.common.jackson.core.JsonProcessingException;
import com.groupbyinc.common.jackson.core.Version;
import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.JsonSerializer;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.SerializerProvider;
import com.groupbyinc.common.jackson.databind.module.SimpleModule;
import com.groupbyinc.common.jackson.databind.node.DoubleNode;
import com.groupbyinc.common.jackson.databind.node.FloatNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"tojson/0"})
public class ToJsonFunction
implements Function {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static String format(double val) {
        String repr;
        if (Double.isNaN(val)) {
            return "null";
        }
        if (Double.isInfinite(val) && val > 0.0) {
            val = Double.MAX_VALUE;
        }
        if (Double.isInfinite(val) && val < 0.0) {
            val = -1.7976931348623157E308;
        }
        if ((repr = Double.toString(val)).contains("E-")) {
            return repr.replace('E', 'e');
        }
        return repr.replace("E", "e+");
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        try {
            return Collections.singletonList(new TextNode(MAPPER.writeValueAsString(in)));
        }
        catch (IOException e) {
            throw new JsonQueryException(e);
        }
    }

    static {
        SimpleModule module = new SimpleModule("JsonQuery", new Version(1, 0, 0, null, "net.thisptr", "jackson-jq"));
        module.addSerializer(DoubleNode.class, new DoubleNodeSerializer());
        module.addSerializer(FloatNode.class, new FloatNodeSerializer());
        MAPPER.registerModule(module);
    }

    private static class FloatNodeSerializer
    extends JsonSerializer<FloatNode> {
        private FloatNodeSerializer() {
        }

        @Override
        public void serialize(FloatNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }

    private static class DoubleNodeSerializer
    extends JsonSerializer<DoubleNode> {
        private DoubleNodeSerializer() {
        }

        @Override
        public void serialize(DoubleNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeRaw(ToJsonFunction.format(value.asDouble()));
        }
    }
}

