/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"tonumber/0"})
public class ToNumberFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (in.isNumber()) {
            return Collections.singletonList(in);
        }
        if (in.isTextual()) {
            double value = Double.parseDouble(in.asText());
            return Collections.singletonList(JsonNodeUtils.asNumericNode(value));
        }
        throw JsonQueryException.format("%s cannot be parsed as a number", new Object[]{in.getNodeType()});
    }
}

