/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.security;

import com.groupbyinc.common.apache.commons.codec.binary.Base64;
import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.security.AesContent;
import com.groupbyinc.common.security.AesUtil;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesDecryption {
    private SecretKey encryptionKey;
    private Cipher cipher;
    private SecretKey macKey;
    private Mac hmac;

    public AesDecryption(String clientKey, String customerId) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        this(clientKey, customerId, (Provider)new BouncyCastleProvider());
    }

    public AesDecryption(String clientKey, String customerId, Provider provider) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        Security.addProvider(provider);
        this.cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(clientKey.toCharArray(), AesUtil.geEncryptSalt(customerId).getBytes(StandardCharsets.UTF_8), 5000, 128);
        PBEKeySpec macSpec = new PBEKeySpec(clientKey.toCharArray(), AesUtil.getMessageAuthenticationCodeSalt(customerId).getBytes(StandardCharsets.UTF_8), 5000, 160);
        this.encryptionKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        this.macKey = new SecretKeySpec(factory.generateSecret(macSpec).getEncoded(), "HmacSHA256");
        this.hmac = Mac.getInstance("HmacSHA256");
        this.hmac.init(this.macKey);
    }

    public String decrypt(AesContent aesContent) throws InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        byte[] macBytes;
        byte[] cipherTextBytes;
        if (aesContent == null) {
            throw new IllegalStateException("cannot decrypt null AesContent");
        }
        if (StringUtils.isBlank(aesContent.getCipherText()) || StringUtils.isBlank(aesContent.getInitialValue()) || StringUtils.isBlank(aesContent.getMessageAuthenticationCode())) {
            throw new IllegalStateException("cipher text, IV and messageAuthenticationCode must be provided");
        }
        byte[] ivBytes = Base64.decodeBase64(aesContent.getInitialValue().getBytes(StandardCharsets.UTF_8));
        if (!this.validateMac(ivBytes, cipherTextBytes = Base64.decodeBase64(aesContent.getCipherText().getBytes(StandardCharsets.UTF_8)), macBytes = Base64.decodeBase64(aesContent.getMessageAuthenticationCode().getBytes(StandardCharsets.UTF_8)))) {
            throw new IllegalStateException("MAC does not match");
        }
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        this.cipher.init(2, (Key)this.encryptionKey, iv);
        byte[] original = this.cipher.doFinal(cipherTextBytes);
        return new String(original, StandardCharsets.UTF_8);
    }

    public boolean validateMac(AesContent aesContent) {
        if (aesContent == null) {
            throw new IllegalStateException("cannot decrypt null AesContent");
        }
        if (StringUtils.isBlank(aesContent.getCipherText()) || StringUtils.isBlank(aesContent.getInitialValue()) || StringUtils.isBlank(aesContent.getMessageAuthenticationCode())) {
            throw new IllegalStateException("cipher text, IV and messageAuthenticationCode must be provided");
        }
        byte[] ivBytes = Base64.decodeBase64(aesContent.getInitialValue().getBytes(StandardCharsets.UTF_8));
        byte[] cipherTextBytes = Base64.decodeBase64(aesContent.getCipherText().getBytes(StandardCharsets.UTF_8));
        byte[] macBytes = Base64.decodeBase64(aesContent.getMessageAuthenticationCode().getBytes(StandardCharsets.UTF_8));
        return this.validateMac(ivBytes, cipherTextBytes, macBytes);
    }

    private boolean validateMac(byte[] ivBytes, byte[] cipherTextBytes, byte[] macBytes) {
        byte[] ciperTextAndIv = new byte[cipherTextBytes.length + ivBytes.length];
        System.arraycopy(cipherTextBytes, 0, ciperTextAndIv, 0, cipherTextBytes.length);
        System.arraycopy(ivBytes, 0, ciperTextAndIv, cipherTextBytes.length, ivBytes.length);
        byte[] mac = this.hmac.doFinal(ciperTextAndIv);
        return MessageDigest.isEqual(mac, macBytes);
    }
}

