/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api.config;

public class ConnectionConfiguration {
    public static final int DEFAULT_CONNECT_TIMEOUT = 1500;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 1500;
    public static final int DEFAULT_SOCKET_TIMEOUT = 3000;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    private int connectTimeout;
    private int connectionRequestTimeout;
    private int socketTimeout;
    private int maxConnections;
    private int maxConnectionsPerRoute;

    public ConnectionConfiguration() {
        this(1500, 1500, 3000);
    }

    public ConnectionConfiguration(int connectTimeout, int connectionRequestTimeout, int socketTimeout) {
        this(connectTimeout, connectionRequestTimeout, socketTimeout, 200, 100);
    }

    public ConnectionConfiguration(int connectTimeout, int connectionRequestTimeout, int socketTimeout, int maxConnections, int maxConnectionsPerRoute) {
        this.connectTimeout = connectTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
        this.checkMaxConnections(maxConnections);
        this.checkMaxConnectionsPerRoute(maxConnectionsPerRoute);
        this.maxConnections = maxConnections;
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConnectionConfiguration setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public ConnectionConfiguration setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public ConnectionConfiguration setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public ConnectionConfiguration setMaxConnections(int maxConnections) {
        this.checkMaxConnections(maxConnections);
        this.maxConnections = maxConnections;
        return this;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public ConnectionConfiguration setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.checkMaxConnectionsPerRoute(maxConnectionsPerRoute);
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    private void checkMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        if (maxConnectionsPerRoute > 100) {
            throw new IllegalStateException("Max active connections per route set above limit of 100");
        }
    }

    private void checkMaxConnections(int maxConnections) {
        if (maxConnections > 200) {
            throw new IllegalStateException("Max active connections set above limit of 200");
        }
    }
}

