/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.commons.text.lookup;

import com.groupbyinc.common.apache.commons.text.lookup.AbstractStringLookup;
import com.groupbyinc.common.apache.commons.text.lookup.IllegalArgumentExceptions;
import java.util.ResourceBundle;

final class ResourceBundleStringLookup
extends AbstractStringLookup {
    static final ResourceBundleStringLookup INSTANCE = new ResourceBundleStringLookup();

    private ResourceBundleStringLookup() {
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        String[] keys = key.split(":");
        int keyLen = keys.length;
        if (keyLen != 2) {
            throw IllegalArgumentExceptions.format("Bad ResourceBundle key format [%s]. Expected format is BundleName:KeyName.", key);
        }
        String bundleName = keys[0];
        String bundleKey = keys[1];
        try {
            return ResourceBundle.getBundle(bundleName).getString(bundleKey);
        }
        catch (Exception e) {
            throw IllegalArgumentExceptions.format(e, "Error looking up ResourceBundle [%s] and key [%s].", bundleName, bundleKey);
        }
    }
}

