/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.IllegalJsonInputException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"@sh/0"})
public class AtShFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (in.isArray()) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (JsonNode i : in) {
                if (i.isTextual()) {
                    tokens.add(this.escape(i.asText()));
                    continue;
                }
                if (i.isValueNode()) {
                    tokens.add(i.asText());
                    continue;
                }
                throw new IllegalJsonInputException((Object)((Object)i.getNodeType()) + " cannot be escaped for shell");
            }
            return Collections.singletonList(new TextNode(Strings.join(" ", tokens)));
        }
        if (in.isTextual()) {
            return Collections.singletonList(new TextNode(this.escape(in.asText())));
        }
        if (in.isValueNode()) {
            return Collections.singletonList(new TextNode(in.asText()));
        }
        throw new IllegalJsonInputException((Object)((Object)in.getNodeType()) + " cannot be escaped for shell");
    }

    public String escape(String text) {
        StringBuilder builder = new StringBuilder("'");
        block3: for (char ch : text.toCharArray()) {
            switch (ch) {
                case '\'': {
                    builder.append("'\\''");
                    continue block3;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        builder.append("'");
        return builder.toString();
    }
}

