/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"fromjson/0"})
public class FromJsonFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("fromjson", in, JsonNodeType.STRING);
        try {
            return Collections.singletonList(scope.getObjectMapper().readTree(in.asText()));
        }
        catch (IOException e) {
            throw new JsonQueryException(e);
        }
    }
}

