/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

@BuiltinFunction(value={"paths/1"})
public class PathsFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Stack<JsonNode> stack = new Stack<JsonNode>();
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        this.applyRecursive(scope, in, out, stack, args.get(0));
        return out;
    }

    private void applyRecursive(Scope scope, JsonNode in, List<JsonNode> out, Stack<JsonNode> stack, JsonQuery predicate) throws JsonQueryException {
        block5: {
            block4: {
                if (!stack.isEmpty()) {
                    for (JsonNode shouldInclude : predicate.apply(in)) {
                        if (!JsonNodeUtils.asBoolean(shouldInclude)) continue;
                        out.add(JsonNodeUtils.asArrayNode(scope.getObjectMapper(), stack));
                    }
                }
                if (!in.isArray()) break block4;
                for (int i = 0; i < in.size(); ++i) {
                    stack.push(new IntNode(i));
                    this.applyRecursive(scope, in.get(i), out, stack, predicate);
                    stack.pop();
                }
                break block5;
            }
            if (!in.isObject()) break block5;
            Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> i = iter.next();
                stack.push(new TextNode(i.getKey()));
                this.applyRecursive(scope, i.getValue(), out, stack, predicate);
                stack.pop();
            }
        }
    }
}

