/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.UnicodeUtils;
import java.util.Collections;
import java.util.List;

@BuiltinFunction(value={"utf8bytelength/0"})
public class Utf8ByteLengthFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        if (!in.isTextual()) {
            throw JsonQueryException.format("%s (%s) only strings have UTF-8 byte length", new Object[]{in.getNodeType(), in});
        }
        return Collections.singletonList(IntNode.valueOf(UnicodeUtils.lengthUtf8(in.asText())));
    }
}

