/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryBreakException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.Pair;
import com.groupbyinc.common.jackson.jq.internal.tree.matcher.PatternMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ReduceExpression
extends JsonQuery {
    private JsonQuery iterExpr;
    private JsonQuery reduceExpr;
    private JsonQuery initExpr;
    private PatternMatcher matcher;

    public ReduceExpression(PatternMatcher matcher, JsonQuery initExpr, JsonQuery reduceExpr, JsonQuery iterExpr) {
        this.matcher = matcher;
        this.initExpr = initExpr;
        this.reduceExpr = reduceExpr;
        this.iterExpr = iterExpr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        try {
            for (JsonNode accumulator : this.initExpr.apply(scope, in)) {
                JsonNode[] accumulators = new JsonNode[]{accumulator};
                try {
                    Scope childScope = Scope.newChildScope(scope);
                    for (JsonNode item : this.iterExpr.apply(scope, in)) {
                        Stack<Pair<String, JsonNode>> stack = new Stack<Pair<String, JsonNode>>();
                        this.matcher.match(scope, item, vars -> {
                            for (int i = vars.size() - 1; i >= 0; --i) {
                                Pair var = (Pair)vars.get(i);
                                childScope.setValue((String)var._1, (JsonNode)var._2);
                            }
                            List<JsonNode> reduceResult = this.reduceExpr.apply(childScope, accumulators[0]);
                            accumulators[0] = reduceResult.isEmpty() ? NullNode.getInstance() : reduceResult.get(reduceResult.size() - 1);
                        }, stack, true);
                    }
                }
                finally {
                    out.add(accumulators[0]);
                }
            }
        }
        catch (JsonQueryBreakException jsonQueryBreakException) {
            // empty catch block
        }
        return out;
    }

    public String toString() {
        return String.format("(reduce %s as %s (%s; %s))", this.iterExpr, this.matcher, this.initExpr, this.reduceExpr);
    }
}

