/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.TextNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import java.util.Collections;
import java.util.List;

public class TryCatch
extends JsonQuery {
    protected JsonQuery tryExpr;
    protected JsonQuery catchExpr;

    public TryCatch(JsonQuery tryExpr, JsonQuery catchExpr) {
        this.tryExpr = tryExpr;
        this.catchExpr = catchExpr;
    }

    public TryCatch(JsonQuery tryExpr) {
        this(tryExpr, null);
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        try {
            return this.tryExpr.apply(scope, in);
        }
        catch (JsonQueryException e) {
            if (this.catchExpr != null) {
                return this.catchExpr.apply(scope, new TextNode(e.getMessage()));
            }
            return Collections.emptyList();
        }
    }

    public String toString() {
        if (this.catchExpr != null) {
            return String.format("(try (%s) catch (%s))", this.tryExpr, this.catchExpr);
        }
        return String.format("(try (%s))", this.tryExpr);
    }

    public static class Question
    extends TryCatch {
        public Question(JsonQuery tryExpr) {
            super(tryExpr);
        }

        @Override
        public String toString() {
            return String.format("(%s)?", this.tryExpr);
        }
    }
}

