/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.util;

import com.groupbyinc.common.jackson.module.afterburner.util.ClassName;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

public class MyClassLoader
extends ClassLoader {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    protected final boolean _cfgUseParentLoader;

    public MyClassLoader(ClassLoader parent, boolean tryToUseParent) {
        super(parent);
        this._cfgUseParentLoader = tryToUseParent;
    }

    public static boolean canAddClassInPackageOf(Class<?> cls) {
        Package beanPackage = cls.getPackage();
        if (beanPackage != null) {
            if (beanPackage.isSealed()) {
                return false;
            }
            String pname = beanPackage.getName();
            if (pname.startsWith("java.") || pname.startsWith("javax.security.")) {
                return false;
            }
        }
        return true;
    }

    public Class<?> loadAndResolve(ClassName className, byte[] byteCode) throws IllegalArgumentException {
        Class<?> impl;
        ClassLoader cl;
        Class<?> old = this.findLoadedClass(className.getDottedName());
        if (old != null) {
            return old;
        }
        MyClassLoader.replaceName(byteCode, className.getSlashedTemplate(), className.getSlashedName());
        if (this._cfgUseParentLoader && (cl = this.getParent()) != null) {
            try {
                Method method = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                return (Class)method.invoke((Object)this.getParent(), className.getDottedName(), byteCode, 0, byteCode.length);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            impl = this.defineClass(className.getDottedName(), byteCode, 0, byteCode.length);
        }
        catch (LinkageError e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            throw new IllegalArgumentException("Failed to load class '" + className + "': " + t.getMessage(), t);
        }
        this.resolveClass(impl);
        return impl;
    }

    public static int replaceName(byte[] byteCode, String from, String to) {
        byte[] toB;
        byte[] fromB = from.getBytes(UTF8);
        int matchLength = fromB.length;
        if (matchLength != (toB = to.getBytes(UTF8)).length) {
            throw new IllegalArgumentException("From String '" + from + "' has different length than To String '" + to + "'");
        }
        int i = 0;
        int count = 0;
        int end = byteCode.length - matchLength;
        block0: while (i <= end) {
            if (byteCode[i++] != fromB[0]) continue;
            for (int j = 1; j < matchLength; ++j) {
                if (fromB[j] != byteCode[i + j - 1]) continue block0;
            }
            ++count;
            System.arraycopy(toB, 0, byteCode, i - 1, matchLength);
            i += matchLength - 1;
        }
        return count;
    }
}

