/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.datatype.jdk8;

import com.groupbyinc.common.jackson.core.JsonGenerator;
import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.databind.JavaType;
import com.groupbyinc.common.jackson.databind.JsonMappingException;
import com.groupbyinc.common.jackson.databind.SerializerProvider;
import com.groupbyinc.common.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.groupbyinc.common.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.groupbyinc.common.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalLong;

final class OptionalLongSerializer
extends StdScalarSerializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsLong());
        } else {
            jgen.writeNull();
        }
    }
}

