/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.FixedScopeQuery;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonQueryFunction
implements Function {
    private JsonQuery body;
    private List<String> params;
    private String name;
    private Scope closure;

    public JsonQueryFunction(String name, List<String> params, JsonQuery body, Scope closure) {
        this.name = name;
        this.params = params;
        this.body = body;
        this.closure = closure;
    }

    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkArgumentCount(this.name, args, this.params.size());
        Scope fnScope = Scope.newChildScope(this.closure);
        fnScope.addFunction(this.name, this.params.size(), this);
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        this.applyRecursive(out, fnScope, scope, args, in, 0);
        return out;
    }

    private void applyRecursive(List<JsonNode> out, Scope fnScope, Scope scope, List<JsonQuery> args, JsonNode in, int i) throws JsonQueryException {
        if (i == this.params.size()) {
            out.addAll(this.body.apply(fnScope, in));
        } else {
            String param = this.params.get(i);
            if (param.startsWith("$")) {
                String argname = param.substring(1);
                for (JsonNode argvalue : args.get(i).apply(scope, in)) {
                    fnScope.setValue(argname, argvalue);
                    this.applyRecursive(out, fnScope, scope, args, in, i + 1);
                }
            } else {
                fnScope.addFunction(param, 0, new JsonQueryFunction(param, Collections.emptyList(), new FixedScopeQuery(scope, args.get(i)), fnScope));
                this.applyRecursive(out, fnScope, scope, args, in, i + 1);
            }
        }
    }
}

