/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.misc;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.ObjectMapper;
import com.groupbyinc.common.jackson.databind.node.ArrayNode;
import com.groupbyinc.common.jackson.databind.node.DoubleNode;
import com.groupbyinc.common.jackson.databind.node.IntNode;
import com.groupbyinc.common.jackson.databind.node.LongNode;
import com.groupbyinc.common.jackson.databind.node.MissingNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.jq.exception.IllegalJsonArgumentException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.Lists;
import com.groupbyinc.common.jackson.jq.internal.misc.Range;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedAllFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedEmptyFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedIndexFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedRangeFieldAccess;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedStringFieldAccess;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonNodeUtils {
    private JsonNodeUtils() {
    }

    public static boolean asBoolean(JsonNode n) {
        if (n == null || n.isNull() || n.isMissingNode()) {
            return false;
        }
        if (n.isBoolean()) {
            return n.asBoolean();
        }
        return true;
    }

    public static boolean isIntegralNumber(JsonNode n) {
        if (!n.isNumber()) {
            return false;
        }
        return n.asDouble() == (double)n.asLong();
    }

    public static JsonNode asNumericNode(long value) {
        if ((long)((int)value) == value) {
            return new IntNode((int)value);
        }
        return new LongNode(value);
    }

    public static JsonNode asNumericNode(double value) {
        if ((double)((int)value) == value) {
            return new IntNode((int)value);
        }
        if ((double)((long)value) == value) {
            return new LongNode((long)value);
        }
        return new DoubleNode(value);
    }

    public static ArrayNode asArrayNode(ObjectMapper mapper, List<JsonNode> values) {
        ArrayNode result = mapper.createArrayNode();
        result.addAll(values);
        return result;
    }

    public static List<JsonNode> asArrayList(ArrayNode in) {
        return Lists.newArrayList(in);
    }

    public static String typeOf(JsonNode in) {
        if (in == null) {
            return "null";
        }
        switch (in.getNodeType()) {
            case ARRAY: {
                return "array";
            }
            case BINARY: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case MISSING: {
                return "null";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return "number";
            }
            case OBJECT: {
                return "object";
            }
            case STRING: {
                return "string";
            }
        }
        throw new IllegalArgumentException("Unknown JsonNodeType: " + (Object)((Object)in.getNodeType()));
    }

    public static void copy(ArrayNode out, JsonNode in) throws JsonQueryException {
        if (!in.isArray()) {
            throw new IllegalJsonArgumentException("input must be ARRAY");
        }
        for (JsonNode i : in) {
            out.add(i);
        }
    }

    public static void copy(ObjectNode out, JsonNode in) throws JsonQueryException {
        if (!in.isObject()) {
            throw new IllegalJsonArgumentException("input must be OBJECT");
        }
        Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
        while (iter.hasNext()) {
            Map.Entry<String, JsonNode> entry = iter.next();
            out.set(entry.getKey(), entry.getValue());
        }
    }

    public static JsonNode mutate(ObjectMapper mapper, JsonNode in, List<ResolvedFieldAccess> path, Mutation mutation, boolean creative) throws JsonQueryException {
        if (path.isEmpty()) {
            return mutation.apply(in);
        }
        ResolvedFieldAccess accessHead = path.get(0);
        List<ResolvedFieldAccess> accessTail = path.subList(1, path.size());
        if (accessHead instanceof ResolvedEmptyFieldAccess) {
            return in;
        }
        if (accessHead instanceof ResolvedIndexFieldAccess) {
            ResolvedIndexFieldAccess access = (ResolvedIndexFieldAccess)accessHead;
            if (in.isNull()) {
                if (!creative) {
                    return NullNode.getInstance();
                }
                ArrayNode result = mapper.createArrayNode();
                for (long index : access.indices()) {
                    if (index < 0L) {
                        throw new JsonQueryException("Out of bounds negative array index");
                    }
                    while (index >= (long)result.size()) {
                        result.add(NullNode.getInstance());
                    }
                    result.set((int)index, JsonNodeUtils.mutate(mapper, NullNode.getInstance(), accessTail, mutation, creative));
                }
                return result;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                ArrayNode tmp = mapper.createArrayNode();
                JsonNodeUtils.copy(tmp, in);
                Iterator<Object> index = access.indices().iterator();
                while (index.hasNext()) {
                    JsonNode newvalue;
                    long index2 = index.next();
                    index2 = index2 >= 0L ? index2 : index2 + (long)in.size();
                    JsonNode value = tmp.get((int)index2);
                    if (value == null && creative) {
                        value = NullNode.getInstance();
                    }
                    if ((newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative)) != null) {
                        while (index2 >= (long)tmp.size()) {
                            tmp.add(NullNode.getInstance());
                        }
                        tmp.set((int)index2, newvalue);
                        continue;
                    }
                    tmp.set((int)index2, MissingNode.getInstance());
                }
                for (JsonNode t : tmp) {
                    if (t.isMissingNode()) continue;
                    result.add(t);
                }
                return result;
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with number", new Object[]{in.getNodeType()});
            }
            return in;
        }
        if (accessHead instanceof ResolvedStringFieldAccess) {
            ResolvedStringFieldAccess access = (ResolvedStringFieldAccess)accessHead;
            if (in.isNull()) {
                if (!creative) {
                    return NullNode.getInstance();
                }
                ObjectNode result = mapper.createObjectNode();
                for (String key : access.keys()) {
                    result.set(key, JsonNodeUtils.mutate(mapper, NullNode.getInstance(), accessTail, mutation, creative));
                }
                return result;
            }
            if (in.isObject()) {
                ObjectNode result = mapper.createObjectNode();
                JsonNodeUtils.copy(result, in);
                for (String key : access.keys()) {
                    JsonNode newvalue;
                    JsonNode value = result.get(key);
                    if (value == null && creative) {
                        value = NullNode.getInstance();
                    }
                    if ((newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative)) == null) {
                        result.remove(key);
                        continue;
                    }
                    if (newvalue == value) continue;
                    result.set(key, newvalue);
                }
                return result;
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with string \"%s\"", new Object[]{in.getNodeType(), access.keys().get(0)});
            }
            return in;
        }
        if (accessHead instanceof ResolvedRangeFieldAccess) {
            ResolvedRangeFieldAccess access = (ResolvedRangeFieldAccess)accessHead;
            if (in.isNull()) {
                JsonNode newvalue = JsonNodeUtils.mutate(mapper, NullNode.getInstance(), accessTail, mutation, creative);
                if (!newvalue.isArray()) {
                    throw new JsonQueryException("A slice of an array can only be assigned another array");
                }
                return newvalue;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                JsonNodeUtils.copy(result, in);
                ArrayNode tmp = mapper.createArrayNode();
                for (Range range : access.ranges()) {
                    range = range.over(result.size());
                    int i = 0;
                    while ((long)i < range.begin) {
                        tmp.add(result.get(i));
                        ++i;
                    }
                    ArrayNode slice = mapper.createArrayNode();
                    int i2 = (int)range.begin;
                    while ((long)i2 < range.end) {
                        slice.add(result.get(i2));
                        ++i2;
                    }
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, slice, accessTail, mutation, creative);
                    if (newvalue != null && newvalue.isArray()) {
                        for (JsonNode t : newvalue) {
                            tmp.add(t);
                        }
                    } else if (newvalue != null) {
                        throw new JsonQueryException("A slice of an array can only be assigned another array");
                    }
                    for (int i3 = (int)range.end; i3 < result.size(); ++i3) {
                        tmp.add(result.get(i3));
                    }
                    result = tmp;
                }
                return result;
            }
            if (in.isTextual()) {
                throw new JsonQueryException("Cannot update field at object index of string");
            }
            if (!accessHead.permissive) {
                throw JsonQueryException.format("Cannot index %s with object", new Object[]{in.getNodeType()});
            }
            return in;
        }
        if (accessHead instanceof ResolvedAllFieldAccess) {
            if (in.isNull()) {
                throw new JsonQueryException("Cannot iterate over null");
            }
            if (in.isObject()) {
                ObjectNode result = mapper.createObjectNode();
                Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
                while (iter.hasNext()) {
                    Map.Entry<String, JsonNode> entry = iter.next();
                    String key = entry.getKey();
                    JsonNode value = entry.getValue();
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative);
                    if (newvalue == null) continue;
                    result.set(key, newvalue);
                }
                return result;
            }
            if (in.isArray()) {
                ArrayNode result = mapper.createArrayNode();
                for (int key = 0; key < in.size(); ++key) {
                    JsonNode value = in.get(key);
                    JsonNode newvalue = JsonNodeUtils.mutate(mapper, value, accessTail, mutation, creative);
                    if (newvalue == null) continue;
                    result.add(newvalue);
                }
                return result;
            }
            throw JsonQueryException.format("Cannot iterate over %s", new Object[]{in.getNodeType()});
        }
        throw new IllegalStateException();
    }

    public static interface Mutation {
        public JsonNode apply(JsonNode var1) throws JsonQueryException;
    }
}

