/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.binaryop.assignment;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.IllegalJsonArgumentException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.operators.BinaryOperator;
import com.groupbyinc.common.jackson.jq.internal.tree.ThisObject;
import com.groupbyinc.common.jackson.jq.internal.tree.binaryop.BinaryOperatorExpression;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.FieldAccess;
import java.util.ArrayList;
import java.util.List;

public class ComplexAssignment
extends BinaryOperatorExpression {
    private BinaryOperator operator;

    public ComplexAssignment(JsonQuery lhs, JsonQuery rhs, BinaryOperator operator) {
        super(lhs, rhs, operator.image() + "=");
        this.operator = operator;
    }

    @Override
    public List<JsonNode> apply(final Scope scope, JsonNode in) throws JsonQueryException {
        if (!(this.lhs instanceof FieldAccess)) {
            throw new IllegalJsonArgumentException("left hand side must be FieldAccess");
        }
        FieldAccess.ResolvedPath resolvedPath = ((FieldAccess)this.lhs).resolvePath(scope, in);
        if (!(resolvedPath.target instanceof ThisObject)) {
            throw new IllegalJsonArgumentException("cannot update value");
        }
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (final JsonNode rvalue : this.rhs.apply(scope, in)) {
            out.add(JsonNodeUtils.mutate(scope.getObjectMapper(), in, resolvedPath.path, new JsonNodeUtils.Mutation(){

                @Override
                public JsonNode apply(JsonNode node) throws JsonQueryException {
                    return ComplexAssignment.this.operator.apply(scope.getObjectMapper(), node, rvalue);
                }
            }, true));
        }
        return out;
    }
}

