/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.deser;

import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.core.JsonToken;
import com.groupbyinc.common.jackson.databind.DeserializationContext;
import com.groupbyinc.common.jackson.databind.deser.SettableBeanProperty;
import com.groupbyinc.common.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.groupbyinc.common.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import java.io.IOException;

public final class SettableLongFieldProperty
extends OptimizedSettableBeanProperty<SettableLongFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableLongFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableLongFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableLongFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        long v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getLongValue() : this._deserializeLong(p, ctxt);
        try {
            this._propertyMutator.longField(bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        long v = ((Number)value).longValue();
        try {
            this._propertyMutator.longField(bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        long l = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getLongValue() : this._deserializeLong(p, ctxt);
        return this.setAndReturn(instance, l);
    }
}

