package com.groupbyinc.api.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;

public class Bias {

  public enum Strength {
    Absolute_Increase,
    Strong_Increase,
    Medium_Increase,
    Weak_Increase,
    Leave_Unchanged,
    Weak_Decrease,
    Medium_Decrease,
    Strong_Decrease,
    Absolute_Decrease
  }

  private String name;
  private String content;

  @JsonProperty private Strength strength;

  public String getName() {
    return name;
  }

  public com.groupbyinc.api.request.Bias setName(String name) {
    this.name = name;
    return this;
  }

  public String getContent() {
    return content;
  }

  public com.groupbyinc.api.request.Bias setContent(String content) {
    this.content = content;
    return this;
  }

  public Strength getStrength() {
    return strength;
  }

  @JsonSetter
  public com.groupbyinc.api.request.Bias setStrength(String strength) {
    this.strength = Strength.valueOf(strength);
    return this;
  }

  @JsonIgnore
  public com.groupbyinc.api.request.Bias setStrength(Strength strength) {
    this.strength = strength;
    return this;
  }
}
