package com.groupbyinc.util.defaults;

import org.apache.commons.lang3.StringUtils;

public class PubsubQueue {

  public enum Type {
    SEARCH_CACHE("search_cache"),
    PERSONALIZATION("personalization");

    private String type;

    public String getType() {
      return this.type;
    }

    Type(String type) {
      this.type = type;
    }
  }

  private PubsubQueue() {
  }

  private static String generateKey(String... parts) {
    return StringUtils.join(parts, '-');
  }

  public static String topicId(String customerId, PubsubQueue.Type type) {
    return generateKey(customerId, type.getType());
  }

  public static String subscriptionId(String customerId, PubsubQueue.Type type, String namespace) {
    return subscriptionId(topicId(customerId, type), namespace);
  }

  public static String subscriptionId(String topicId, String namespace) {
    return generateKey(topicId, namespace);
  }

  public static Type parseType(String type) {
    for (Type t : Type.values()) {
      if (StringUtils.equals(t.getType(), type)) {
        return t;
      }
    }
    throw new IllegalArgumentException("unable to match PubsubQueue.Type");
  }
}
