/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.databind.node.ObjectNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectConstruction
extends JsonQuery {
    private List<FieldDef> fields = new ArrayList<FieldDef>();

    public void addField(JsonQuery keyExpr, JsonQuery valueExpr) {
        this.fields.add(new FieldDef(keyExpr, valueExpr));
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        HashMap<String, JsonNode> tmp = new HashMap<String, JsonNode>();
        ObjectConstruction.applyRecursive(scope, in, out, this.fields, tmp);
        return out;
    }

    private static void applyRecursive(Scope scope, JsonNode in, List<JsonNode> out, List<FieldDef> fields, Map<String, JsonNode> tmp) throws JsonQueryException {
        if (fields.size() == 0) {
            ObjectNode obj = scope.getObjectMapper().createObjectNode();
            for (Map.Entry<String, JsonNode> e : tmp.entrySet()) {
                obj.set(e.getKey(), e.getValue());
            }
            out.add(obj);
            return;
        }
        FieldDef def = fields.get(0);
        List<String> keys = def.keys(scope, in);
        for (String key : keys) {
            for (JsonNode value : def.values(scope, in, key)) {
                tmp.put(key, value);
                ObjectConstruction.applyRecursive(scope, in, out, fields.subList(1, fields.size()), tmp);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        String sep = "";
        for (FieldDef field : this.fields) {
            builder.append(sep);
            builder.append(field);
            sep = ",";
        }
        builder.append("}");
        return builder.toString();
    }

    private static class FieldDef {
        public final JsonQuery keyExpr;
        public final JsonQuery valueExpr;

        public FieldDef(JsonQuery keyExpr, JsonQuery valueExpr) {
            this.keyExpr = keyExpr;
            this.valueExpr = valueExpr;
        }

        public List<JsonNode> values(Scope scope, JsonNode in, String key) throws JsonQueryException {
            if (this.valueExpr == null) {
                JsonNode tmp = in.get(key);
                return Collections.singletonList(tmp == null ? NullNode.getInstance() : tmp);
            }
            return this.valueExpr.apply(scope, in);
        }

        public List<String> keys(Scope scope, JsonNode in) throws JsonQueryException {
            ArrayList<String> result = new ArrayList<String>();
            for (JsonNode keyNode : this.keyExpr.apply(scope, in)) {
                if (!keyNode.isTextual()) {
                    throw new JsonQueryException("key must evaluate to string");
                }
                result.add(keyNode.asText());
            }
            return result;
        }

        public String toString() {
            String result = "(" + this.keyExpr.toString() + ")";
            if (this.valueExpr != null) {
                return result + ": " + this.valueExpr;
            }
            return result;
        }
    }
}

