/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.misc.JsonNodeUtils;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResolvedStringFieldAccess
extends ResolvedFieldAccess {
    private List<String> keys;

    public List<String> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public ResolvedStringFieldAccess(boolean permissive, List<String> keys) {
        super(permissive);
        this.keys = keys;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        for (String key : this.keys) {
            if (in.isNull()) {
                out.add(NullNode.getInstance());
                continue;
            }
            if (in.isObject()) {
                JsonNode n = in.get(key);
                out.add(n == null ? NullNode.getInstance() : n);
                continue;
            }
            if (this.permissive) continue;
            throw new JsonQueryException(String.format("Cannot index %s with string \"%s\"", JsonNodeUtils.typeOf(in), key));
        }
        return out;
    }
}

