/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;
import com.groupbyinc.common.util.exception.GroupByUtilException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);
    private static final String ERROR_MSG_RESOURCE_PATH_BLANK = "Unable to read resource, resource name cannot be empty";
    private static final String TEMP_FILENAME_PREFIX = "jvmTempFile_";

    private ResourceUtils() {
    }

    public static String getPath(String resourcePath) {
        return ResourceUtils.getUrl(resourcePath).getPath();
    }

    public static URL getUrl(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        return ResourceUtils.class.getResource(resourcePath);
    }

    public static File getAsFile(String resourcePath) {
        return new File(ResourceUtils.getUrl(resourcePath).getPath());
    }

    public static File copyResourceToTempFile(String resourcePath) {
        File file;
        LOG.trace("Copying resource [{}] into temporary file", (Object)resourcePath);
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        try {
            file = File.createTempFile(TEMP_FILENAME_PREFIX, null);
        }
        catch (IOException e) {
            LOG.error("Unable to create temp file on filesystem, check that you have write access", (Throwable)e);
            throw new GroupByUtilException("Unable to create temp file on filesystem, check that you have write access", e);
        }
        LOG.debug("Reading resource [{}] and writing to temporary file: {}", (Object)resourcePath, (Object)file.getAbsolutePath());
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            ResourceUtils.pipeResourceIntoBufferedOutputStream(resourcePath, bufferedOutputStream);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException(e.getMessage(), e);
        }
        return file;
    }

    public static void pipeResourceIntoBufferedOutputStream(String resourcePath, BufferedOutputStream bufferedOutputStream) {
        try (BufferedInputStream bufferedInputStream = ResourceUtils.readResourceIntoBufferedInputStream(resourcePath);){
            ResourceUtils.pipe(bufferedInputStream, bufferedOutputStream);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException("Exception occurred while piping input into output", e);
        }
    }

    public static BufferedInputStream readResourceIntoBufferedInputStream(String resourcePath) {
        return new BufferedInputStream(ResourceUtils.readResourceIntoInputStream(resourcePath));
    }

    private static void pipe(BufferedInputStream input, BufferedOutputStream output) throws IOException {
        int character;
        while ((character = input.read()) != -1) {
            output.write(character);
        }
        output.flush();
    }

    public static InputStream readResourceIntoInputStream(String resourcePath) {
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        InputStream resourceInputStream = ResourceUtils.class.getResourceAsStream(resourcePath);
        if (resourceInputStream == null) {
            String errorMessage = "Unable to read resource into input stream, please check that resource exists";
            LOG.error("{}: {}", (Object)errorMessage, (Object)resourcePath);
            throw new IllegalArgumentException(errorMessage);
        }
        return resourceInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readResourceIntoString(String resourcePath) {
        LOG.trace("Reading resource [{}] into memory (String)", (Object)resourcePath);
        if (StringUtils.isBlank(resourcePath)) {
            throw new IllegalArgumentException(ERROR_MSG_RESOURCE_PATH_BLANK);
        }
        StringWriter stringWriter = new StringWriter();
        try (BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);){
            ResourceUtils.pipeResourceIntoBufferedWriter(resourcePath, bufferedWriter);
            String string = stringWriter.toString();
            return string;
        }
        catch (GroupByUtilException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException("Exception occurred while reading resource into string", e);
        }
    }

    public static void pipeResourceIntoBufferedWriter(String resourcePath, BufferedWriter bufferedWriter) {
        try (BufferedReader bufferedReader = ResourceUtils.readResourceIntoBufferedReader(resourcePath);){
            ResourceUtils.pipe(bufferedReader, bufferedWriter);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new GroupByUtilException("Exception occurred while piping input into output", e);
        }
    }

    public static BufferedReader readResourceIntoBufferedReader(String resourcePath) {
        return new BufferedReader(new InputStreamReader(ResourceUtils.readResourceIntoInputStream(resourcePath), StandardCharsets.UTF_8));
    }

    private static void pipe(BufferedReader input, BufferedWriter output) throws IOException {
        int character;
        while ((character = input.read()) != -1) {
            output.write(character);
        }
        output.flush();
    }
}

