/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.commons.text.lookup;

import com.groupbyinc.common.apache.commons.text.lookup.AbstractStringLookup;
import com.groupbyinc.common.apache.commons.text.lookup.IllegalArgumentExceptions;
import java.util.ResourceBundle;

final class ResourceBundleStringLookup
extends AbstractStringLookup {
    private final String bundleName;
    static final ResourceBundleStringLookup INSTANCE = new ResourceBundleStringLookup();

    private ResourceBundleStringLookup() {
        this(null);
    }

    ResourceBundleStringLookup(String bundleName) {
        this.bundleName = bundleName;
    }

    @Override
    public String lookup(String key) {
        boolean anyBundle;
        if (key == null) {
            return null;
        }
        String[] keys = key.split(SPLIT_STR);
        int keyLen = keys.length;
        boolean bl = anyBundle = this.bundleName == null;
        if (anyBundle && keyLen != 2) {
            throw IllegalArgumentExceptions.format("Bad resource bundle key format [%s]; expected format is BundleName:KeyName.", key);
        }
        if (this.bundleName != null && keyLen != 1) {
            throw IllegalArgumentExceptions.format("Bad resource bundle key format [%s]; expected format is KeyName.", key);
        }
        String keyBundleName = anyBundle ? keys[0] : this.bundleName;
        String bundleKey = anyBundle ? keys[1] : keys[0];
        try {
            return ResourceBundle.getBundle(keyBundleName).getString(bundleKey);
        }
        catch (Exception e) {
            throw IllegalArgumentExceptions.format(e, "Error looking up resource bundle [%s] and key [%s].", keyBundleName, bundleKey);
        }
    }
}

