/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.tree.fieldaccess.resolved.ResolvedFieldAccess;
import java.util.ArrayList;
import java.util.List;

public abstract class FieldAccess
extends JsonQuery {
    protected JsonQuery target;
    protected boolean permissive;

    public FieldAccess(JsonQuery target, boolean permissive) {
        this.target = target;
        this.permissive = permissive;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        ResolvedFieldAccess resolvedFieldAccess = this.resolveFieldAccess(scope, in);
        for (JsonNode i : this.target.apply(scope, in)) {
            out.addAll(resolvedFieldAccess.apply(scope, i));
        }
        return out;
    }

    public abstract ResolvedFieldAccess resolveFieldAccess(Scope var1, JsonNode var2) throws JsonQueryException;

    public ResolvedPath resolvePath(Scope scope, JsonNode in) throws JsonQueryException {
        ResolvedPath resolvedPath = this.target instanceof FieldAccess ? ((FieldAccess)this.target).resolvePath(scope, in) : new ResolvedPath(this.target);
        return resolvedPath.access(this.resolveFieldAccess(scope, in));
    }

    public static class ResolvedPath {
        public JsonQuery target;
        public List<ResolvedFieldAccess> path;

        public ResolvedPath(JsonQuery target) {
            this.target = target;
            this.path = new ArrayList<ResolvedFieldAccess>();
        }

        public ResolvedPath access(ResolvedFieldAccess path) {
            this.path.add(path);
            return this;
        }
    }
}

