/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.functions;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.DoubleNode;
import com.groupbyinc.common.jackson.databind.node.JsonNodeType;
import com.groupbyinc.common.jackson.jq.Function;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.internal.BuiltinFunction;
import com.groupbyinc.common.jackson.jq.internal.misc.Preconditions;
import java.util.Collections;
import java.util.List;

public abstract class MathFunction
implements Function {
    @Override
    public List<JsonNode> apply(Scope scope, List<JsonQuery> args, JsonNode in) throws JsonQueryException {
        Preconditions.checkInputType("mathfunc", in, JsonNodeType.NUMBER);
        return Collections.singletonList(new DoubleNode(this.f(in.asDouble())));
    }

    protected abstract double f(double var1);

    @BuiltinFunction(value={"log2/0"})
    public static class Log2Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log10(v) / Math.log10(2.0);
        }
    }

    @BuiltinFunction(value={"sqrt/0"})
    public static class SqrtFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sqrt(v);
        }
    }

    @BuiltinFunction(value={"sin/0"})
    public static class SinFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sin(v);
        }
    }

    @BuiltinFunction(value={"floor/0"})
    public static class FloorFunction
    extends MathFunction {
        @Override
        protected double f(double f) {
            return Math.floor(f);
        }
    }

    @BuiltinFunction(value={"cos/0"})
    public static class CosFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.cos(v);
        }
    }

    @BuiltinFunction(value={"atan/0"})
    public static class AtanFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.atan(v);
        }
    }
}

