/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.jq.internal.tree.matcher.matchers;

import com.groupbyinc.common.jackson.databind.JsonNode;
import com.groupbyinc.common.jackson.databind.node.NullNode;
import com.groupbyinc.common.jackson.jq.JsonQuery;
import com.groupbyinc.common.jackson.jq.Scope;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryException;
import com.groupbyinc.common.jackson.jq.exception.JsonQueryTypeException;
import com.groupbyinc.common.jackson.jq.internal.misc.Functional;
import com.groupbyinc.common.jackson.jq.internal.misc.Pair;
import com.groupbyinc.common.jackson.jq.internal.tree.matcher.PatternMatcher;
import java.util.List;
import java.util.Stack;

public class ObjectMatcher
implements PatternMatcher {
    private List<Pair<JsonQuery, PatternMatcher>> matchers;

    public ObjectMatcher(List<Pair<JsonQuery, PatternMatcher>> matchers) {
        this.matchers = matchers;
    }

    private void recursive(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit, int index) throws JsonQueryException {
        if (index >= this.matchers.size()) {
            return;
        }
        Pair<JsonQuery, PatternMatcher> kvexpr = this.matchers.get(index);
        JsonQuery keyexpr = (JsonQuery)kvexpr._1;
        PatternMatcher matcher = (PatternMatcher)kvexpr._2;
        for (JsonNode key : keyexpr.apply(scope, in)) {
            if (!key.isTextual()) {
                throw JsonQueryTypeException.format("Cannot index %s with %s", new Object[]{in.getNodeType(), key.getNodeType()});
            }
            JsonNode value = in.get(key.asText());
            int size = accumulate.size();
            matcher.match(scope, value != null ? value : NullNode.getInstance(), out, accumulate, emit && index == this.matchers.size() - 1);
            this.recursive(scope, in, out, accumulate, emit, index + 1);
            accumulate.setSize(size);
        }
    }

    @Override
    public void match(Scope scope, JsonNode in, Functional.Consumer<List<Pair<String, JsonNode>>> out, Stack<Pair<String, JsonNode>> accumulate, boolean emit) throws JsonQueryException {
        if (!in.isObject() && !in.isNull()) {
            throw JsonQueryTypeException.format("Cannot index %s with string", new Object[]{in.getNodeType()});
        }
        this.recursive(scope, in, out, accumulate, emit, 0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        String sep = "";
        for (Pair<JsonQuery, PatternMatcher> entry : this.matchers) {
            sb.append(sep);
            sb.append(entry._1);
            sb.append(": ");
            sb.append(entry._2);
            sep = ", ";
        }
        sb.append("}");
        return sb.toString();
    }
}

