/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.util.defaults;

import com.groupbyinc.common.apache.commons.lang3.StringUtils;

public class PubsubQueue {
    private PubsubQueue() {
    }

    private static String generateKey(String ... parts) {
        return StringUtils.join((Object[])parts, '-');
    }

    public static String topicId(String customerId, Type type) {
        return PubsubQueue.generateKey(customerId, type.getType());
    }

    public static String subscriptionId(String customerId, Type type, String namespace) {
        return PubsubQueue.subscriptionId(PubsubQueue.topicId(customerId, type), namespace);
    }

    public static String subscriptionId(String topicId, String namespace) {
        return PubsubQueue.generateKey(topicId, namespace);
    }

    public static Type parseType(String type) {
        for (Type t : Type.values()) {
            if (!StringUtils.equals(t.getType(), type)) continue;
            return t;
        }
        throw new IllegalArgumentException("unable to match PubsubQueue.Type");
    }

    public static enum Type {
        SEARCH_CACHE("search_cache"),
        PERSONALIZATION("personalization");

        private String type;

        public String getType() {
            return this.type;
        }

        private Type(String type) {
            this.type = type;
        }
    }
}

