/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.http.impl.io;

import com.groupbyinc.common.apache.http.HttpRequest;
import com.groupbyinc.common.apache.http.HttpRequestFactory;
import com.groupbyinc.common.apache.http.annotation.Contract;
import com.groupbyinc.common.apache.http.annotation.ThreadingBehavior;
import com.groupbyinc.common.apache.http.config.MessageConstraints;
import com.groupbyinc.common.apache.http.impl.DefaultHttpRequestFactory;
import com.groupbyinc.common.apache.http.impl.io.DefaultHttpRequestParser;
import com.groupbyinc.common.apache.http.io.HttpMessageParser;
import com.groupbyinc.common.apache.http.io.HttpMessageParserFactory;
import com.groupbyinc.common.apache.http.io.SessionInputBuffer;
import com.groupbyinc.common.apache.http.message.BasicLineParser;
import com.groupbyinc.common.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

