/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.databind.ext;

import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.core.JsonToken;
import com.groupbyinc.common.jackson.databind.DeserializationContext;
import com.groupbyinc.common.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class NioPathDeserializer
extends StdScalarDeserializer<Path> {
    private static final long serialVersionUID = 1L;

    public NioPathDeserializer() {
        super(Path.class);
    }

    @Override
    public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            return (Path)ctxt.handleUnexpectedToken(Path.class, p);
        }
        String value = p.getText();
        if (value.indexOf(58) < 0) {
            return Paths.get(value, new String[0]);
        }
        try {
            URI uri = new URI(value);
            return Paths.get(uri);
        }
        catch (URISyntaxException e) {
            return (Path)ctxt.handleInstantiationProblem(this.handledType(), value, e);
        }
    }
}

