/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.client.protocol;

import com.groupbyinc.common.commons.logging.Log;
import com.groupbyinc.common.commons.logging.LogFactory;
import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpRequest;
import com.groupbyinc.common.http.HttpRequestInterceptor;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.client.protocol.HttpClientContext;
import com.groupbyinc.common.http.conn.routing.RouteInfo;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

