/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.conn;

import com.groupbyinc.common.http.HttpResponse;
import com.groupbyinc.common.http.HttpResponseFactory;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.config.MessageConstraints;
import com.groupbyinc.common.http.impl.DefaultHttpResponseFactory;
import com.groupbyinc.common.http.impl.conn.DefaultHttpResponseParser;
import com.groupbyinc.common.http.io.HttpMessageParser;
import com.groupbyinc.common.http.io.HttpMessageParserFactory;
import com.groupbyinc.common.http.io.SessionInputBuffer;
import com.groupbyinc.common.http.message.BasicLineParser;
import com.groupbyinc.common.http.message.LineParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

