/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.cookie;

import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.client.utils.DateUtils;
import com.groupbyinc.common.http.cookie.MalformedCookieException;
import com.groupbyinc.common.http.cookie.SetCookie;
import com.groupbyinc.common.http.impl.cookie.AbstractCookieAttributeHandler;
import com.groupbyinc.common.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }
}

