/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.protocol;

import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpRequest;
import com.groupbyinc.common.http.HttpRequestInterceptor;
import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.params.HttpParams;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

