/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.collections4;

import com.groupbyinc.common.util.collections4.Factory;
import com.groupbyinc.common.util.collections4.functors.ConstantFactory;
import com.groupbyinc.common.util.collections4.functors.ExceptionFactory;
import com.groupbyinc.common.util.collections4.functors.InstantiateFactory;
import com.groupbyinc.common.util.collections4.functors.PrototypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryUtils {
    private FactoryUtils() {
    }

    public static <T> Factory<T> exceptionFactory() {
        return ExceptionFactory.exceptionFactory();
    }

    public static <T> Factory<T> nullFactory() {
        return ConstantFactory.constantFactory(null);
    }

    public static <T> Factory<T> constantFactory(T constantToReturn) {
        return ConstantFactory.constantFactory(constantToReturn);
    }

    public static <T> Factory<T> prototypeFactory(T prototype) {
        return PrototypeFactory.prototypeFactory(prototype);
    }

    public static <T> Factory<T> instantiateFactory(Class<T> classToInstantiate) {
        return InstantiateFactory.instantiateFactory(classToInstantiate, null, null);
    }

    public static <T> Factory<T> instantiateFactory(Class<T> classToInstantiate, Class<?>[] paramTypes, Object[] args) {
        return InstantiateFactory.instantiateFactory(classToInstantiate, paramTypes, args);
    }
}

