/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.impl.cookie;

import com.groupbyinc.common.http.annotation.Immutable;
import com.groupbyinc.common.http.cookie.Cookie;
import com.groupbyinc.common.http.cookie.CookieOrigin;
import com.groupbyinc.common.http.cookie.CookieRestrictionViolationException;
import com.groupbyinc.common.http.cookie.MalformedCookieException;
import com.groupbyinc.common.http.cookie.SetCookie;
import com.groupbyinc.common.http.impl.cookie.AbstractCookieAttributeHandler;
import com.groupbyinc.common.http.util.Args;

@Immutable
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().length() == 0) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }
}

