/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.http.protocol;

import com.groupbyinc.common.http.HttpException;
import com.groupbyinc.common.http.HttpResponse;
import com.groupbyinc.common.http.HttpResponseInterceptor;
import com.groupbyinc.common.http.annotation.ThreadSafe;
import com.groupbyinc.common.http.protocol.HttpContext;
import com.groupbyinc.common.http.protocol.HttpDateGenerator;
import com.groupbyinc.common.http.util.Args;
import java.io.IOException;

@ThreadSafe
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

