/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.ser;

import com.groupbyinc.common.jackson.core.JsonGenerator;
import com.groupbyinc.common.jackson.databind.JsonSerializer;
import com.groupbyinc.common.jackson.databind.SerializerProvider;
import com.groupbyinc.common.jackson.databind.ser.BeanPropertyWriter;
import com.groupbyinc.common.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.groupbyinc.common.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class IntFieldPropertyWriter
extends OptimizedBeanPropertyWriter<IntFieldPropertyWriter> {
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;

    public IntFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableInt = 0;
            this._suppressableIntSet = true;
        } else if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new IntFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public IntFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new IntFieldPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.intField(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, false);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeFieldName(this._fastName);
            gen.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._propertyAccessor.intField(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, gen, prov, t, true);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeNumber(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

