/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.collections4.functors;

import com.groupbyinc.common.util.collections4.Predicate;
import com.groupbyinc.common.util.collections4.functors.AbstractQuantifierPredicate;
import com.groupbyinc.common.util.collections4.functors.FalsePredicate;
import com.groupbyinc.common.util.collections4.functors.FunctorUtils;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnyPredicate<T>
extends AbstractQuantifierPredicate<T> {
    private static final long serialVersionUID = 7429999530934647542L;

    public static <T> Predicate<T> anyPredicate(Predicate<? super T> ... predicates) {
        FunctorUtils.validate(predicates);
        if (predicates.length == 0) {
            return FalsePredicate.falsePredicate();
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new AnyPredicate<T>(FunctorUtils.copy(predicates));
    }

    public static <T> Predicate<T> anyPredicate(Collection<? extends Predicate<T>> predicates) {
        Predicate<T>[] preds = FunctorUtils.validate(predicates);
        if (preds.length == 0) {
            return FalsePredicate.falsePredicate();
        }
        if (preds.length == 1) {
            return preds[0];
        }
        return new AnyPredicate(preds);
    }

    public AnyPredicate(Predicate<? super T> ... predicates) {
        super(predicates);
    }

    @Override
    public boolean evaluate(T object) {
        for (Predicate iPredicate : this.iPredicates) {
            if (!iPredicate.evaluate(object)) continue;
            return true;
        }
        return false;
    }
}

