/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.util.collections4.functors;

import com.groupbyinc.common.util.collections4.Closure;
import com.groupbyinc.common.util.collections4.functors.NOPClosure;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForClosure<E>
implements Closure<E>,
Serializable {
    private static final long serialVersionUID = -1190120533393621674L;
    private final int iCount;
    private final Closure<? super E> iClosure;

    public static <E> Closure<E> forClosure(int count, Closure<? super E> closure) {
        if (count <= 0 || closure == null) {
            return NOPClosure.nopClosure();
        }
        if (count == 1) {
            return closure;
        }
        return new ForClosure<E>(count, closure);
    }

    public ForClosure(int count, Closure<? super E> closure) {
        this.iCount = count;
        this.iClosure = closure;
    }

    @Override
    public void execute(E input) {
        for (int i = 0; i < this.iCount; ++i) {
            this.iClosure.execute(input);
        }
    }

    public Closure<? super E> getClosure() {
        return this.iClosure;
    }

    public int getCount() {
        return this.iCount;
    }
}

