/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.api;

import com.groupbyinc.api.AbstractQuery;
import com.groupbyinc.api.model.Sort;
import com.groupbyinc.api.request.RefinementsRequest;
import com.groupbyinc.api.request.Request;
import com.groupbyinc.api.request.RestrictNavigation;
import com.groupbyinc.common.util.lang3.StringUtils;

public class Query
extends AbstractQuery<Request, Query> {
    private boolean accurateCounts = false;
    private String partialFields;
    private String requiredFields;
    private Sort sort;

    @Override
    protected Request generateRequest() {
        Request request = new Request();
        request.setPartialFields(this.partialFields);
        request.setRequiredFields(this.requiredFields);
        request.setAccurateCounts(this.accurateCounts ? "1" : null);
        if (this.sort != null && !StringUtils.equals(this.sort.getField(), Sort.RELEVANCE.getField())) {
            request.setSort(Query.convertSort(this.sort));
        }
        return request;
    }

    @Override
    protected RefinementsRequest<Request> populateRefinementRequest() {
        return new RefinementsRequest<Request>().setOriginalQuery(this.generateRequest());
    }

    @Deprecated
    public boolean isAccurateCounts() {
        return this.accurateCounts;
    }

    @Deprecated
    public void setAccurateCounts(boolean accurateCounts) {
        this.accurateCounts = accurateCounts;
    }

    public String getPartialFields() {
        return this.partialFields;
    }

    @Deprecated
    public Query setPartialFields(String partialFields) {
        this.partialFields = partialFields;
        return this;
    }

    @Deprecated
    public String getRequiredFields() {
        return this.requiredFields;
    }

    @Deprecated
    public Query setRequiredFields(String requiredFields) {
        this.requiredFields = requiredFields;
        return this;
    }

    @Deprecated
    public String getLanguageRestrict() {
        return "lang_" + this.getLanguage();
    }

    @Deprecated
    public Query setLanguageRestrict(String languageRestrict) {
        String lang = StringUtils.isNotBlank(languageRestrict) && languageRestrict.startsWith("lang_") ? languageRestrict.substring("lang_".length()) : languageRestrict;
        this.setLanguage(lang);
        return this;
    }

    @Deprecated
    public String getInterfaceLanguage() {
        return this.getLanguage();
    }

    @Deprecated
    public Query setInterfaceLanguage(String interfaceLanguage) {
        this.setLanguage(interfaceLanguage);
        return this;
    }

    public RestrictNavigation getRestrictNavigation() {
        return this.restrictNavigation;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Query setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public Query setPruneRefinements(boolean pruneRefinements) {
        return (Query)super.setPruneRefinements(pruneRefinements);
    }
}

