/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.jackson.module.afterburner.deser;

import com.groupbyinc.common.jackson.core.Base64Variants;
import com.groupbyinc.common.jackson.core.JsonParser;
import com.groupbyinc.common.jackson.core.JsonProcessingException;
import com.groupbyinc.common.jackson.core.JsonToken;
import com.groupbyinc.common.jackson.databind.DeserializationContext;
import com.groupbyinc.common.jackson.databind.JsonDeserializer;
import com.groupbyinc.common.jackson.databind.PropertyName;
import com.groupbyinc.common.jackson.databind.deser.SettableBeanProperty;
import com.groupbyinc.common.jackson.databind.introspect.AnnotatedMember;
import com.groupbyinc.common.jackson.module.afterburner.deser.BeanPropertyMutator;
import java.io.IOException;
import java.lang.annotation.Annotation;

abstract class OptimizedSettableBeanProperty<T extends OptimizedSettableBeanProperty<T>>
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final SettableBeanProperty _originalSettable;
    protected final BeanPropertyMutator _propertyMutator;
    protected final int _optimizedIndex;

    public OptimizedSettableBeanProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src);
        this._originalSettable = src;
        this._propertyMutator = mutator;
        this._optimizedIndex = index;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, JsonDeserializer<?> deser) {
        super(src, deser);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    protected OptimizedSettableBeanProperty(OptimizedSettableBeanProperty<T> src, PropertyName name) {
        super(src, name);
        this._originalSettable = src;
        this._propertyMutator = src._propertyMutator;
        this._optimizedIndex = src._optimizedIndex;
    }

    public abstract T withMutator(BeanPropertyMutator var1);

    public abstract T withValueDeserializer(JsonDeserializer<?> var1);

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> ann) {
        return this._originalSettable.getAnnotation(ann);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._originalSettable.getMember();
    }

    @Override
    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    @Override
    public abstract void set(Object var1, Object var2) throws IOException;

    @Override
    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException;

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        return this._originalSettable.setAndReturn(instance, value);
    }

    public SettableBeanProperty getOriginalProperty() {
        return this._originalSettable;
    }

    public int getOptimizedIndex() {
        return this._optimizedIndex;
    }

    protected final boolean _deserializeBoolean(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        return p.getValueAsBoolean();
    }

    protected final String _deserializeString(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getValueAsString();
        if (text != null) {
            return text;
        }
        return this._convertToString(p, ctxt);
    }

    protected final String _convertToString(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken curr = p.getCurrentToken();
        if (curr == JsonToken.VALUE_NULL) {
            if (this._valueDeserializer == null) {
                return null;
            }
            return (String)this._valueDeserializer.getNullValue(ctxt);
        }
        if (curr == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        if (curr.isScalarValue()) {
            return p.getText();
        }
        throw ctxt.mappingException(String.class);
    }
}

