/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.http.impl.cookie;

import com.groupbyinc.common.apache.http.annotation.Immutable;
import com.groupbyinc.common.apache.http.cookie.ClientCookie;
import com.groupbyinc.common.apache.http.cookie.Cookie;
import com.groupbyinc.common.apache.http.cookie.CookieAttributeHandler;
import com.groupbyinc.common.apache.http.cookie.CookieOrigin;
import com.groupbyinc.common.apache.http.cookie.CookieRestrictionViolationException;
import com.groupbyinc.common.apache.http.cookie.MalformedCookieException;
import com.groupbyinc.common.apache.http.cookie.SetCookie;
import com.groupbyinc.common.apache.http.cookie.SetCookie2;
import com.groupbyinc.common.apache.http.util.Args;

@Immutable
public class RFC2965VersionAttributeHandler
implements CookieAttributeHandler {
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }
}

