/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.commons.collections4.functors;

import com.groupbyinc.common.apache.commons.collections4.Predicate;
import com.groupbyinc.common.apache.commons.collections4.functors.AbstractQuantifierPredicate;
import com.groupbyinc.common.apache.commons.collections4.functors.FalsePredicate;
import com.groupbyinc.common.apache.commons.collections4.functors.FunctorUtils;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OnePredicate<T>
extends AbstractQuantifierPredicate<T> {
    private static final long serialVersionUID = -8125389089924745785L;

    public static <T> Predicate<T> onePredicate(Predicate<? super T> ... predicates) {
        FunctorUtils.validate(predicates);
        if (predicates.length == 0) {
            return FalsePredicate.falsePredicate();
        }
        if (predicates.length == 1) {
            return predicates[0];
        }
        return new OnePredicate<T>(FunctorUtils.copy(predicates));
    }

    public static <T> Predicate<T> onePredicate(Collection<? extends Predicate<T>> predicates) {
        Predicate<T>[] preds = FunctorUtils.validate(predicates);
        return new OnePredicate(preds);
    }

    public OnePredicate(Predicate<? super T> ... predicates) {
        super(predicates);
    }

    @Override
    public boolean evaluate(T object) {
        boolean match = false;
        for (Predicate iPredicate : this.iPredicates) {
            if (!iPredicate.evaluate(object)) continue;
            if (match) {
                return false;
            }
            match = true;
        }
        return match;
    }
}

