/*
 * Decompiled with CFR 0.152.
 */
package com.groupbyinc.common.apache.http.client.protocol;

import com.groupbyinc.common.apache.commons.logging.Log;
import com.groupbyinc.common.apache.commons.logging.LogFactory;
import com.groupbyinc.common.apache.http.HttpException;
import com.groupbyinc.common.apache.http.HttpRequest;
import com.groupbyinc.common.apache.http.HttpRequestInterceptor;
import com.groupbyinc.common.apache.http.annotation.Immutable;
import com.groupbyinc.common.apache.http.client.protocol.HttpClientContext;
import com.groupbyinc.common.apache.http.conn.routing.RouteInfo;
import com.groupbyinc.common.apache.http.protocol.HttpContext;
import com.groupbyinc.common.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PROXY_CONN_DIRECTIVE = "Proxy-Connection";

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader(PROXY_CONN_DIRECTIVE)) {
            request.addHeader(PROXY_CONN_DIRECTIVE, "Keep-Alive");
        }
    }
}

